//
//  importConfigurations.m
//  SweetFleet
//
//  Created by Claus Richter on 4/3/18.
//
//

#import "importConfigurations.h"

#import "ViewController.h"

#import "EquipmentViewController.h"
#import "EquipmentPackages.h"
#import "EquipPackagesManager.h"
#import "PackagesTotalsTVController.h"
#import "NSURLSession+SynchronousTask.h"

#define NSLog(...)



@interface importConfigurations ()

@end

typedef void(^myCompletion)(BOOL);

@implementation importConfigurations {
    
    
    ViewController* mainControllerClass_;
    
}


- (void)didMoveToParentViewController:(UIViewController *)parent {
    [super didMoveToParentViewController:parent];
    
}

// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@                                       @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@                                       @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@       NEVER  NSLOG  our URLs!!!!      @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@                                       @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@                                       @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@



- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    
    
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (EquipmentPackages*)currentFlightEquipmentPackage {
    return [[EquipPackagesManager sharedInstance] packageForKey:@"SASS"];
}

- (void) loadAllAvailableAircraftListFromServer {
    
    //NSLog(@"loadAllAvailableAircraftListFromServer");
    
    //NSURL *URL;
    //NSStringEncoding encoding;
    NSError *error;
    
    NSString *baseDataURL = @"https://www.gyronimo.online/0aaGyroData/allAvailableAircraft/";
    NSString *urlWithConfigID =  @"https://www.gyronimoserver.com/api/flightpadaircraftlist/";
    NSURL *url = [NSURL URLWithString:urlWithConfigID];
    //NSError *error = nil;
    NSURLResponse *response = nil;
    NSData *data = [[NSURLSession sharedSession] sendSynchronousDataTaskWithURL:url returningResponse:&response error:&error];  
    NSDictionary *dictionaryAll = [NSJSONSerialization JSONObjectWithData:data options:0 error:&error]; 
    
    
    NSArray *dictArray = [dictionaryAll valueForKey:@"data"];
    //NSLog(@"dictArray: %@", dictArray);  
    
    
    NSString *allText = @"";
    allText = [allText stringByAppendingString: @"All Available Aircraft"];
    allText = [allText stringByAppendingString: @"|version =^8"];
    
    for(int i =0; i<dictArray.count; i++) {  
        
        NSDictionary *dictHeader = [dictArray objectAtIndex:i];
        //NSLog(@"dictHeader: %@", dictHeader);  
        
        allText = [allText stringByAppendingString: @"|"];
        
        NSString *addString = [ [NSString alloc] initWithFormat:@"%@^",  [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"type"]] ];  
        
        allText = [allText stringByAppendingString: addString];
        
        NSString *headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"manufacturer"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ];                
        allText = [allText stringByAppendingString: addString];
        
       
        headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"model"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ]; 
        allText = [allText stringByAppendingString: addString];
        
      
        headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"variant"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ]; 
        allText = [allText stringByAppendingString: addString];
        
        
        headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"callsign"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ]; 
        allText = [allText stringByAppendingString: addString];
        
  
        headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"unit"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ]; 
        allText = [allText stringByAppendingString: addString];
        
       
        headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"BEW"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ]; 
        allText = [allText stringByAppendingString: addString];        
       
        headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"moment_long"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ]; 
        allText = [allText stringByAppendingString: addString];        
       
        headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"moment_lat"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ]; 
        allText = [allText stringByAppendingString: addString];
              
        headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"MTOW"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ]; 
        allText = [allText stringByAppendingString: addString];        
        
        headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"max_fuel"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ]; 
        allText = [allText stringByAppendingString: addString];        
        
        headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"description_line1"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ]; 
        allText = [allText stringByAppendingString: addString];
        
        
        headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"description_line2"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ]; 
        allText = [allText stringByAppendingString: addString];
        
        
        headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"category"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ]; 
        allText = [allText stringByAppendingString: addString];        
          
        headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"version"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ]; 
        allText = [allText stringByAppendingString: addString];            
        
            
        headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"image_name"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ];         
        allText = [allText stringByAppendingString: addString];
              
        headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"id_backend"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ];
        allText = [allText stringByAppendingString: addString];
        
 
        headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"display_manufacturer"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ];
        allText = [allText stringByAppendingString: addString];
        

        headerString = [[NSString alloc] initWithFormat:@"%@", [dictHeader valueForKey: @"display_name"]];
        if ([headerString isEqualToString:@"<null>"]) { headerString = @"";}
        addString = [ [NSString alloc] initWithFormat:@"%@^",  headerString ];
        allText = [allText stringByAppendingString: addString];
        
        
    }
    
    NSString *importedText = allText;
    [[NSUserDefaults standardUserDefaults]  setObject:importedText  forKey:@"allAvailableAircraftText"]; 
    
    
    if (importedText) {
        
        int flagLoadThumbnails = 1;
        NSString *imageDataUrl;
        NSData *imageData;
        UIImage *image;
        NSData *imageDataPNG;
        
        //make array to load aircraft images:  
        NSMutableDictionary *ACthumbnailDictionary = [[NSMutableDictionary alloc] init];
        NSMutableArray *ACimages = [[NSMutableArray alloc] init];         
        NSString *allAvailText = importedText;
        NSCharacterSet* charSet = [NSCharacterSet characterSetWithCharactersInString:@"|"];
        NSArray *components = [allAvailText componentsSeparatedByCharactersInSet:charSet];
        //NSLog(@"components %@", components);                          
        for(int i =0; i<components.count; i++) {        
            NSArray* componentItems  = [[components objectAtIndex:i] componentsSeparatedByString:@"^"];        
            if (componentItems.count > 1) {  
                
                
                if ([[componentItems objectAtIndex:0] isEqualToString:@"Heli"] || [[componentItems objectAtIndex:0] isEqualToString:@"FixedWing"]) { 
                    
                    if (![ACimages containsObject:[componentItems objectAtIndex:15]  ]) {                         
                        if ([[componentItems objectAtIndex:15] length] > 1 ) {
                            [ACimages addObject: [componentItems objectAtIndex:15] ];    
                            //NSLog(@"loading  ACimage: %@", [componentItems objectAtIndex:15]);                             
                            //gyronimo.online/0aaGyroData/allAvailableAircraft/thumb_DA42.png
                            //gyronimo.online/0aaGyroData/allAvailableAircraft/thumb_C172
                            //load ac images                             
                            NSString *imageName =  [componentItems objectAtIndex:15];
                            //NSLog(@"1 imageName: %@", imageName);  
                            imageName  = [ imageName stringByReplacingOccurrencesOfString:@" " withString:@""];
                            imageName  = [ imageName stringByReplacingOccurrencesOfString:@"\n" withString:@""];   
                            //NSLog(@"2 imageName: %@", imageName);
                            NSString *imageDiskName = [ [NSString alloc] initWithFormat:@"thumb_%@.jpg", imageName]; 
                            NSString *imageDiskName2 = [ [NSString alloc] initWithFormat:@"thumb_%@", imageName];
                            //NSLog(@"3 imageName: %@", imageDiskName);
                            UIImage *tempImage;
                            NSString* myImagePath = [[NSBundle mainBundle] pathForResource:imageDiskName2 ofType:@"jpg"];                            
                            if (myImagePath != nil) {
                                tempImage = [UIImage imageNamed:imageDiskName];                                
                                //NSLog(@"i have this image on file %@", imageDiskName );                                 
                                ACthumbnailDictionary[imageDiskName] = @"onFile";
                            }else{
                                imageDataUrl = [ [NSString alloc] initWithFormat:@"%@thumb_%@.jpg", baseDataURL, imageName];                             
                                //NSLog(@"need to load imageDataUrl %@", imageDataUrl );
                                //NSLog(@"pic not on file: %@", imageName );
                                NSURL *imageURL = [NSURL URLWithString: imageDataUrl ];
                                //NSLog(@"imageURL %@", imageURL );                                
                                imageData = [NSData dataWithContentsOfURL:imageURL];
                                image = [UIImage imageWithData:imageData];
                                imageDataPNG = [NSData dataWithData:UIImagePNGRepresentation(image)];                                
                                if (image) {
                                    NSString *imageToSave = [NSString stringWithFormat:@"thumb_%@", imageName ];
                                    ACthumbnailDictionary[imageToSave] = imageData ;
                                    //NSLog(@"saving image -%@-", imageToSave);
                                }else{
                                    NSString *imageToSave = [NSString stringWithFormat:@"thumb_%@", imageName ];
                                    ACthumbnailDictionary[imageToSave] = imageData ;
                                    //NSLog(@"!!!! NO PERF IMAGE for -%@- ", imageToSave);
                                }                                
                            }
                        }                           
                    }
                }//end           
            }
        }
        
        if (flagLoadThumbnails == 1) {
            [[NSUserDefaults standardUserDefaults]  setObject: ACthumbnailDictionary  forKey:@"ACthumbnailDictionary"];
        }        
        
        //NSLog(@"ACthumbnailDictionary %@", ACthumbnailDictionary);
        
        
        
        NSNotification *myNotification = [NSNotification notificationWithName:@"notificationLoadedAllAircraftList"
                                                                       object:self 
                                                                     userInfo:nil];
        [[NSNotificationCenter defaultCenter] postNotification:myNotification];
        
    }
    
    
    
    
    
}

- (void) checkForUpdatesEquipment {
    
     customerDataURL = [[NSUserDefaults standardUserDefaults]  stringForKey: @"customerDataURL"]; // includes customer name
    
    NSURL *URL;
    NSStringEncoding encoding;
    NSError *error;
    
    NSString *availableACTypesURL = [ [NSString alloc] initWithFormat:@"%@%@", customerDataURL,  @"allEquipment.txt" ];
    URL = [NSURL URLWithString: availableACTypesURL];
    [[NSURLCache sharedURLCache] removeAllCachedResponses];
    [[NSURLCache sharedURLCache] setDiskCapacity:0];
    [[NSURLCache sharedURLCache] setMemoryCapacity:0];
    importedText = [NSString stringWithContentsOfURL:URL usedEncoding:&encoding error:&error];
    NSCharacterSet* charSet = [NSCharacterSet characterSetWithCharactersInString:@"|"];
    NSArray *components = [importedText componentsSeparatedByCharactersInSet:charSet];
    //NSLog(@"components %@", [components objectAtIndex:0] );
    NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
    [defaults  setObject: [components objectAtIndex:0]    forKey:@"updatedEquipmentVersion"];
    //NSLog(@"updated equipmentVersion %@", [components objectAtIndex:0] );
    
}

- (void) addArrayHeader {
    
    [_arrayName1 addObject: @""];
    [_arrayName2 addObject: @""];
    [_arrayName3 addObject: @""];
    [_arrayName4 addObject: @""];
    [_arrayName5 addObject: @""];
    [_arrayName6 addObject: @""];
    [_arrayName7 addObject: @""];
    [_arrayName8 addObject: @""];
    [_arrayName9 addObject: @""];
    [_arrayName10 addObject: @""];
    [_arrayName11 addObject: @""];
    [_arrayName12 addObject: @""];
    [_arrayName13 addObject: @""];
    [_arrayName14 addObject: @""];
    [_arrayName15 addObject: @""];
    [_arrayName16 addObject: @""];
    [_arrayName17 addObject: @""];
    [_arrayName18 addObject: @""];
    [_arrayName19 addObject: @""];
    [_arrayName20 addObject: @""];
    [_arrayName21 addObject: @""];
    [_arrayName22 addObject: @""];
    [_arrayName23 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName25 addObject: @""];
    
    [_arrayName1 addObject: @"Item"];
    [_arrayName2 addObject: @"Mass"];
    [_arrayName3 addObject: @"LON STA"];
    [_arrayName4 addObject: @"LON MOM"];
    [_arrayName5 addObject: @"LAT STA"];
    [_arrayName6 addObject: @"LAT MOM"];
    [_arrayName7 addObject: @""];
    [_arrayName8 addObject: @"1"];
    [_arrayName9 addObject: @"300"];
    [_arrayName10 addObject: @"0"];
    [_arrayName11 addObject: @"0"];
    [_arrayName12 addObject: @"0"];
    [_arrayName13 addObject: @"0"];
    [_arrayName14 addObject: @"noSlider"];
    [_arrayName15 addObject: @""];
    [_arrayName16 addObject: @""];
    [_arrayName17 addObject: @""];
    [_arrayName18 addObject: @""];
    [_arrayName19 addObject: @""];
    [_arrayName20 addObject: @""];
    [_arrayName21 addObject: @""];
    [_arrayName22 addObject: @""];
    [_arrayName23 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName25 addObject: @""];
    
    [_arrayName1 addObject: @"Units"];
    [_arrayName2 addObject: @"kg"];
    [_arrayName3 addObject: @"mm"];
    [_arrayName4 addObject: @"kg.mm"];
    [_arrayName5 addObject: @"mm"];
    [_arrayName6 addObject: @"kg.mm"];
    [_arrayName7 addObject: @""];
    [_arrayName8 addObject: @"1"];
    [_arrayName9 addObject: @"300"];
    [_arrayName10 addObject: @"0"];
    [_arrayName11 addObject: @"0"];
    [_arrayName12 addObject: @"0"];
    [_arrayName13 addObject: @"0"];
    [_arrayName14 addObject: @"noSlider"];
    [_arrayName15 addObject: @""];
    [_arrayName16 addObject: @""];
    [_arrayName17 addObject: @""];
    [_arrayName18 addObject: @""];
    [_arrayName19 addObject: @""];
    [_arrayName20 addObject: @""];
    [_arrayName21 addObject: @""];
    [_arrayName22 addObject: @""];
    [_arrayName23 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName25 addObject: @""];
    
    [_arrayName1 addObject: @"BEM"];
    [_arrayName2 addObject: @"0"];
    [_arrayName3 addObject: @"0"];
    [_arrayName4 addObject: @"0"];
    [_arrayName5 addObject: @"0"];
    [_arrayName6 addObject: @"0"];
    [_arrayName7 addObject: @""];
    [_arrayName8 addObject: @"1"];
    [_arrayName9 addObject: @"300"];
    [_arrayName10 addObject: @"0"];
    [_arrayName11 addObject: @"0"];
    [_arrayName12 addObject: @"0"];
    [_arrayName13 addObject: @"0"];
    [_arrayName14 addObject: @"noSlider"];
    [_arrayName15 addObject: @""];
    [_arrayName16 addObject: @""];
    [_arrayName17 addObject: @""];
    [_arrayName18 addObject: @""];
    [_arrayName19 addObject: @""];
    [_arrayName20 addObject: @""];
    [_arrayName21 addObject: @""];
    [_arrayName22 addObject: @""];
    [_arrayName23 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName25 addObject: @""];
    
    
}

- (void) addArrayResults {
    
    [_arrayName1 addObject: @"ZFM"];
    [_arrayName2 addObject: @""];
    [_arrayName3 addObject: @""];
    [_arrayName4 addObject: @""];
    [_arrayName5 addObject: @""];
    [_arrayName6 addObject: @""];
    [_arrayName7 addObject: @""];
    [_arrayName8 addObject: @"0"];
    [_arrayName9 addObject: @""];
    [_arrayName10 addObject: @""];
    [_arrayName11 addObject: @""];
    [_arrayName12 addObject: @""];
    [_arrayName13 addObject: @""];
    [_arrayName14 addObject: @"result"];
    [_arrayName15 addObject: @""];
    [_arrayName16 addObject: @""];
    [_arrayName17 addObject: @""];
    [_arrayName18 addObject: @""];
    [_arrayName19 addObject: @""];
    [_arrayName20 addObject: @""];
    
    [_arrayName1 addObject: @"TO Fuel"];
    [_arrayName2 addObject: @""];
    [_arrayName3 addObject: @""];
    [_arrayName4 addObject: @""];
    [_arrayName5 addObject: @""];
    [_arrayName6 addObject: @""];
    [_arrayName7 addObject: @""];
    [_arrayName8 addObject: @"0"];
    [_arrayName9 addObject: @""];
    [_arrayName10 addObject: @""];
    [_arrayName11 addObject: @""];
    [_arrayName12 addObject: @""];
    [_arrayName13 addObject: @""];
    [_arrayName14 addObject: @"result"];
    [_arrayName15 addObject: @""];
    [_arrayName16 addObject: @""];
    [_arrayName17 addObject: @""];
    [_arrayName18 addObject: @""];
    [_arrayName19 addObject: @""];
    [_arrayName20 addObject: @""];
    
    [_arrayName1 addObject: @"TOM"];
    [_arrayName2 addObject: @""];
    [_arrayName3 addObject: @""];
    [_arrayName4 addObject: @""];
    [_arrayName5 addObject: @""];
    [_arrayName6 addObject: @""];
    [_arrayName7 addObject: @""];
    [_arrayName8 addObject: @"0"];
    [_arrayName9 addObject: @""];
    [_arrayName10 addObject: @""];
    [_arrayName11 addObject: @""];
    [_arrayName12 addObject: @""];
    [_arrayName13 addObject: @""];
    [_arrayName14 addObject: @"result"];
    [_arrayName15 addObject: @""];
    [_arrayName16 addObject: @""];
    [_arrayName17 addObject: @""];
    [_arrayName18 addObject: @""];
    [_arrayName19 addObject: @""];
    [_arrayName20 addObject: @""];
    
    
    
    [_arrayName1 addObject: @"Ldg. Fuel"];
    [_arrayName2 addObject: @""];
    [_arrayName3 addObject: @""];
    [_arrayName4 addObject: @""];
    [_arrayName5 addObject: @""];
    [_arrayName6 addObject: @""];
    [_arrayName7 addObject: @""];
    [_arrayName8 addObject: @"0"];
    [_arrayName9 addObject: @""];
    [_arrayName10 addObject: @""];
    [_arrayName11 addObject: @""];
    [_arrayName12 addObject: @""];
    [_arrayName13 addObject: @""];
    [_arrayName14 addObject: @"result"];
    [_arrayName15 addObject: @""];
    [_arrayName16 addObject: @""];
    [_arrayName17 addObject: @""];
    [_arrayName18 addObject: @""];
    [_arrayName19 addObject: @""];
    [_arrayName20 addObject: @""];
    
    [_arrayName1 addObject: @"LDM"];
    [_arrayName2 addObject: @""];
    [_arrayName3 addObject: @""];
    [_arrayName4 addObject: @""];
    [_arrayName5 addObject: @""];
    [_arrayName6 addObject: @""];
    [_arrayName7 addObject: @""];
    [_arrayName8 addObject: @"0"];
    [_arrayName9 addObject: @""];
    [_arrayName10 addObject: @""];
    [_arrayName11 addObject: @""];
    [_arrayName12 addObject: @""];
    [_arrayName13 addObject: @""];
    [_arrayName14 addObject: @"result"];
    [_arrayName15 addObject: @""];
    [_arrayName16 addObject: @""];
    [_arrayName17 addObject: @""];
    [_arrayName18 addObject: @""];
    [_arrayName19 addObject: @""];
    [_arrayName20 addObject: @""];
    
    
    
    
}

- (void) addArrayEmpty {
    
    [_arrayName1 addObject: @""];
    [_arrayName2 addObject: @""];
    [_arrayName3 addObject: @""];
    [_arrayName4 addObject: @""];
    [_arrayName5 addObject: @""];
    [_arrayName6 addObject: @""];
    [_arrayName7 addObject: @""];
    [_arrayName8 addObject: @""];
    [_arrayName9 addObject: @""];
    [_arrayName10 addObject: @""];
    [_arrayName11 addObject: @""];
    [_arrayName12 addObject: @""];
    [_arrayName13 addObject: @""];
    [_arrayName14 addObject: @""];
    [_arrayName15 addObject: @""];
    [_arrayName16 addObject: @""];
    [_arrayName17 addObject: @""];
    [_arrayName18 addObject: @""];
    [_arrayName19 addObject: @""];
    [_arrayName20 addObject: @""];
    
    
}

- (void) setArrays21to25 {
    
    //NSLog(@"[setArrays21to25 dictionaryItem %@", dictionaryItem);
  
    
    [_arrayName21 addObject: @"Weight Units"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cweightunits"] ] ]; //5
    [_arrayName21 addObject: @"Max Ramp"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cmaxramp"] ] ]; //7
    [_arrayName21 addObject: @"Max TOW"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cmaxtow"] ] ]; //9
    [_arrayName21 addObject: @"Max LDW"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cmaxldw"] ] ]; //11
    [_arrayName21 addObject: @"Calc Lateral Fuel"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"ccalclateralfuel"] ] ]; //13
    [_arrayName21 addObject: @"Fuel Units"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cfuelunits"] ] ]; //15
    [_arrayName21 addObject: @"Fuel Volume"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"ctankmaxfuelvolume"] ] ]; //17
    [_arrayName21 addObject: @"specific FW"];
    [_arrayName21 addObject: @"lbs/gal"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cfactorlbsgal"] ] ]; // 20
    [_arrayName21 addObject: @"kg/liter"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cfactorkgliter"] ] ]; //22
    [_arrayName21 addObject: @"enter mode"];
    [_arrayName21 addObject: [dictionaryItem valueForKey: @"centermode"]]; // 24
    [_arrayName21 addObject: @"(mass/vol)"];
    [_arrayName21 addObject: @"Fuel Flow"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cfuelflowlbsperh"] ] ]; //27
    [_arrayName21 addObject: @"Preset Main"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cpresetmain"] ] ]; //29
    [_arrayName21 addObject: @"Preset Landing"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cpresetlanding"] ] ];
    [_arrayName21 addObject: @"QuickLoad Preset"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cquickloadpreset"] ] ];
    [_arrayName21 addObject: @"Mode"];
    [_arrayName21 addObject: @"Plan"];
    [_arrayName21 addObject: @"yUp Heli Individual"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cyupheliindividual"] ] ];
    [_arrayName21 addObject: @"yUp Heli Plan"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"yupheliplan"] ] ];
    [_arrayName21 addObject: @"Swap off/on"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"swapoffon"] ] ];
    [_arrayName21 addObject: @"Quick/Crew (q/c)"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cquickcrew"] ] ];
    [_arrayName21 addObject: @"ID / WID / WN"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cidwidwn"] ] ];
    [_arrayName21 addObject: @"Color Code (yellow/Green)"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"ccolorcode"] ] ];
    [_arrayName21 addObject: @"Flight/Legs"];
    [_arrayName21 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cflightlegs"] ] ];
    [_arrayName21 addObject: @""];
    
    //NSLog(@"2");
    
    [_arrayName22 addObject: @"longarmfrontseat"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"clongarmfrontseat"] ] ];
    [_arrayName22 addObject: @"longarmrearseat"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"clongarmrearseat"] ] ];
    [_arrayName22 addObject: @"keep next to zero"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"ckeeptozero"] ] ];
    [_arrayName22 addObject: @"latarmrightseat"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"clatarmrightseat"] ] ];
    [_arrayName22 addObject: @" "];
    [_arrayName22 addObject: @"SeatsFront"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cseatsfront"] ] ];
    [_arrayName22 addObject: @"SeatsRear"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cseatsrear"] ] ];
    [_arrayName22 addObject: @"Seat Width"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cseatwidth"] ] ];
    [_arrayName22 addObject: @"Seat Height"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cseatheight"] ] ];
    [_arrayName22 addObject: @"Lat Center"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"clatcenter"] ] ];
    [_arrayName22 addObject: @"Lat Right"];
    //[_arrayName22 addObject: [dictionaryItem valueForKey: @"clatright"]];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%.0f", [[dictionaryItem valueForKey: @"clatright"] floatValue] - [ [dictionaryItem valueForKey: @"clatcenter"]floatValue] ]];
    [_arrayName22 addObject: @"AC X"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cacx"] ] ];
    [_arrayName22 addObject: @"AC Y"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cacy"] ] ];
    [_arrayName22 addObject: @"AC width"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cacwidth"] ] ];
    [_arrayName22 addObject: @"AC height"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cacheight"] ] ];
    [_arrayName22 addObject: @""];
    [_arrayName22 addObject: @""];
    [_arrayName22 addObject: @""];
    [_arrayName22 addObject: @"Fuel Panel Height"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cfuelpanelheight"] ] ];
    [_arrayName22 addObject: @"Fuel Panel Start"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cfuelpanelstart"] ] ];
    [_arrayName22 addObject: @"largeTopView"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"clargetopview"] ] ];
    [_arrayName22 addObject: @"config/equip label"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cconfigequiplabel"] ] ];
    [_arrayName22 addObject: @"special Manifest"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cspecialmanifest"] ] ];
    [_arrayName22 addObject: @"Setup Options"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"csetupoptions"] ] ];
    [_arrayName22 addObject: @"CGexternal"];
    [_arrayName22 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"ccgexternal"] ] ];
    [_arrayName22 addObject: @""];
    
    //NSLog(@"3");
    [_arrayName23 addObject: @"Date (US/EU)"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"csetupoptions"] ] ];
    [_arrayName23 addObject: @"Picker Minute Interval"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cpickerminuteinterval"] ] ];
    [_arrayName23 addObject: @"picker Locale"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cpickerlocale"] ] ];
    [_arrayName23 addObject: @"Config Stations Start"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cconfigstationsstart"] ] ];
    [_arrayName23 addObject: @"Config Stations End"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cconfigstationsend"] ] ];
    [_arrayName23 addObject: @"Manifest Export"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cmanifestexport"] ] ];
    [_arrayName23 addObject: @"Summary Export"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"csummaryexport"] ] ];
    [_arrayName23 addObject: @"allow Interor Edit"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"callowinteroredit"] ] ];
    [_arrayName23 addObject: @"check Margin"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"ccheckmargin"] ] ];
    [_arrayName23 addObject: @"margin percent"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cmarginpercent"] ] ];
    [_arrayName23 addObject: @"second CG envelope"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"csecondcgenvelope"] ] ];
    
    //NSLog(@"check %@", [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"csecondcgenvelope"] ] );
    
    
    [_arrayName23 addObject: @"linePilot"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"clinepilot"] ] ];//27
    [_arrayName23 addObject: @"calc max External/Hoist"]; //28
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"ccalcmaxexternalorhoist"] ] ];//29
    [_arrayName23 addObject: @""]; //30
    [_arrayName23 addObject: @"Allow Equip Change"]; //31
    [_arrayName23 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"callowequipchange"] ] ]; //32
    [_arrayName23 addObject: @"FWD/AFT CG Check"]; //33
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cfwdaftcgcheck"] ] ];
    [_arrayName23 addObject: @"Aux Fuel Volume"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cauxfuelvolume"] ] ];
    [_arrayName23 addObject: @"Date Format"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cdateformat"] ] ];
    [_arrayName23 addObject: @"Flt Data Elements"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cfltdataelements"] ] ];
    [_arrayName23 addObject: @"Perf Button Width"];
    // ************************************************************************************
    [_arrayName23 addObject: @"150"];
    // ************************************************************************************
    [_arrayName23 addObject: @"Allow BEW Override"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"callowbewoverride"] ] ];
    [_arrayName23 addObject: @"LOCK RESET if not sent"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"clockresetifnotsent"] ] ];
    [_arrayName23 addObject: @"if Units (meter)"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cifunitsaremeter"] ] ];
    [_arrayName23 addObject: @"Set Line as Free Load"];
    [_arrayName23 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"csetlineasfreeload"] ] ];
    
    //NSLog(@"4");
    [_arrayName24 addObject: @"Boxed Sliders"];
    [_arrayName24 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cboxedsliders"] ] ];    
    [_arrayName24 addObject: @"Box Alpha"];
    [_arrayName24 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cboxalpha"] ] ];
    [_arrayName24 addObject: @"Slider Alpha"];
    [_arrayName24 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cslideralpha"] ] ];
    [_arrayName24 addObject: @"Box Gap"];
    [_arrayName24 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cslideralpha"] ] ];
    [_arrayName24 addObject: @"Top Box Ypos"];
    [_arrayName24 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"ctopypos"] ] ];
    [_arrayName24 addObject: @"BoxStyle / cross Style"];
    [_arrayName24 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cboxstyle"] ] ];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    [_arrayName24 addObject: @""];
    
   
    [_arrayName25 addObject: @"Port Land Both"];
    [_arrayName25 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cportlandboth"] ] ]; //5
    [_arrayName25 addObject: @"Risk Assess"];
    [_arrayName25 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"criskassess"] ] ]; // 7
    [_arrayName25 addObject: @"DocViewer"];
    [_arrayName25 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cdocviewer"] ] ]; // 9
    [_arrayName25 addObject: @"Int. Configurator"];
    [_arrayName25 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"cintconfigurator"] ] ]; // 11
    [_arrayName25 addObject: @"Selector Buttons"];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"selectorbuttons"] ] ]; //13
    [_arrayName25 addObject: @"Factor CrewWeight"]; 
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"factorcrewweight"] ] ]; //15
    [_arrayName25 addObject: @"Flight Types"];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"flighttypes"] ] ]; //17
    [_arrayName25 addObject: @"SupplyFuelVolume"];
    [_arrayName25 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"supplyfuelvolume"] ] ]; //19
    [_arrayName25 addObject: @"Subtract Supply Fuel"];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"subtractsupplyfuel"] ] ]; //21
    [_arrayName25 addObject: @"signalComingFromBackend"];//do not change this!
    [_arrayName25 addObject: @""];
    [_arrayName25 addObject: @"second max avail text"];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"secondmaxavailtext"] ] ]; //25
    [_arrayName25 addObject: @"depends on display btn"];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"dependsondisplaybutton"] ] ]; //27;
    [_arrayName25 addObject: @"Max Avail on Manifest"];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"maxavailonmanifest"] ] ]; //29;
    [_arrayName25 addObject: @"Fuel Presets"];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"fuelpresets"] ] ]; //31;
    [_arrayName25 addObject: @"Auto Land Fuel"];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"autolandingfuelpreset"] ] ]; //33;
    [_arrayName25 addObject: @"CG Alarm "];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"extra1"] ] ]; //35;
    [_arrayName25 addObject: @"Envi Standard Setting"];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"extra2"] ] ]; //37;
    [_arrayName25 addObject: @"Enter OAT or ISA"];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"extra3"] ] ]; //39;
    [_arrayName25 addObject: @"extra 2 FuelTanks"];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"extra4"] ] ]; //41;
    [_arrayName25 addObject: @"extra 5 altimeter US"];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"extra5"] ] ]; //43;
    [_arrayName25 addObject: @"extra 6"];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"extra6"] ] ]; //45;
    [_arrayName25 addObject: @"extra 7"];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"extra7"] ] ]; //47;
    [_arrayName25 addObject: @"extra 8"];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"extra8"] ] ]; //49;
    [_arrayName25 addObject: @"extra 9"];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"extra9"] ] ]; //51;
    [_arrayName25 addObject: @"extra 10"];
    [_arrayName25 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"extra10"] ] ]; //53;
    

    
}

- (void) getDataFromAPI {
    
    //NSLog(@"getDataFromAPI");
    
    _arrayName1 = [[NSMutableArray alloc] init];
    _arrayName2 = [[NSMutableArray alloc] init];
    _arrayName3 = [[NSMutableArray alloc] init];
    _arrayName4 = [[NSMutableArray alloc] init];
    _arrayName5 = [[NSMutableArray alloc] init];
    _arrayName6 = [[NSMutableArray alloc] init];
    _arrayName7 = [[NSMutableArray alloc] init];
    _arrayName8 = [[NSMutableArray alloc] init];
    _arrayName9 = [[NSMutableArray alloc] init];
    _arrayName10 = [[NSMutableArray alloc] init];
    _arrayName11 = [[NSMutableArray alloc] init];
    _arrayName12 = [[NSMutableArray alloc] init];
    _arrayName13 = [[NSMutableArray alloc] init];
    _arrayName14 = [[NSMutableArray alloc] init];
    _arrayName15 = [[NSMutableArray alloc] init];
    _arrayName16 = [[NSMutableArray alloc] init];
    _arrayName17 = [[NSMutableArray alloc] init];
    _arrayName18 = [[NSMutableArray alloc] init];
    _arrayName19 = [[NSMutableArray alloc] init];
    _arrayName20 = [[NSMutableArray alloc] init];
    _arrayName21 = [[NSMutableArray alloc] init];
    _arrayName22 = [[NSMutableArray alloc] init];
    _arrayName23 = [[NSMutableArray alloc] init];
    _arrayName24 = [[NSMutableArray alloc] init];
    _arrayName25 = [[NSMutableArray alloc] init];
    
   
    
    NSString *urlWithConfigID =  [ [NSString alloc] initWithFormat:@"https://www.gyronimoserver.com/api/configComponent/%@", configID];
    NSURL *url = [NSURL URLWithString:urlWithConfigID];
    NSError *error = nil;
    NSURLResponse *response = nil;
    NSData *data = [[NSURLSession sharedSession] sendSynchronousDataTaskWithURL:url returningResponse:&response error:&error];
    
    
    [self addArrayHeader];
    
    NSDictionary *dictionary = [NSJSONSerialization JSONObjectWithData:data options:0 error:&error];
    NSLog(@"dictionary: %@", dictionary);
    NSArray *itemsArray = [dictionary valueForKey:@"components"];
    //NSLog(@"itemsArray: %@", itemsArray);
    
    int checkIfZFMwasAdded = 0;
    
    for(int i =1; i<itemsArray.count; i++) {
        //NSLog(@"itemsArray number %d", i );
        NSDictionary *dictionaryItem = [itemsArray objectAtIndex:i];
        //NSLog(@"dictionaryItem %@", dictionaryItem );
        //NSLog(@"adding istationname %@",  [dictionaryItem objectForKey: @"istationname"] );
        [_arrayName1 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"istationname"] ] ];
        [_arrayName2 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"ioccweight"] ] ];
        [_arrayName3 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"ilatarm"] ] ];
        [_arrayName4 addObject:  [ [NSString alloc] initWithFormat:@"%.0f", [[dictionaryItem objectForKey: @"ioccweight"] floatValue] * [[dictionaryItem objectForKey: @"ilatarm"]floatValue] ]];
        
        if ([ [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"istationname"] ] isEqualToString:@"ZFM"]) {
            checkIfZFMwasAdded = 1;
        }
        
        [_arrayName5 addObject:  [dictionaryItem objectForKey: @"ilongarm"]];
        [_arrayName6 addObject:  [ [NSString alloc] initWithFormat:@"%.0f", [[dictionaryItem objectForKey: @"ioccweight"] floatValue] * [[dictionaryItem objectForKey: @"ilongarm"]floatValue] ]];
        [_arrayName7 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"ioccname"] ] ];
        [_arrayName8 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"ionoff"] ] ];
        [_arrayName9 addObject:  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"imaxweight"] ] ];
        [_arrayName10 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"iseatsymbol"] ] ];
        [_arrayName11 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"ilongoffset"] ] ];
        [_arrayName12 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"iseatlabel"] ] ];
        
        //NSLog(@"adding iseatlabel%@", [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"iseatlabel"] ] );
        
        [_arrayName13 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"ilatoffset"] ] ];
        [_arrayName14 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"ispecial"] ] ];
        
        [_arrayName15 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"irotation"] ] ];
        [_arrayName16 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"ileftright"] ] ];
        [_arrayName17 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"iweight"] ] ];
        [_arrayName18 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"iarmalternate"] ] ];
        [_arrayName19 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"isymbolwidth"] ] ];
        [_arrayName20 addObject: [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"isymbolheight"] ] ];
    }
    
    // replace config name
    
    if (checkIfZFMwasAdded == 0) {
         [self addArrayResults];
    }
    
    
   
    float currentArrayCount = _arrayName1.count;
    int arraysToAdd = 51 - currentArrayCount;
    for(int i =0; i<arraysToAdd; i++) {
        [self addArrayEmpty];
    }
    NSMutableArray *configArray = [[NSMutableArray alloc] init];
    [configArray addObject:[dictionary valueForKey:@"configurations"]];
    dictionaryItem = [[NSDictionary alloc] init];
    dictionaryItem = [configArray objectAtIndex:0];
    //NSLog(@"dictionaryItem %@", dictionaryItem);
    
    [self setArrays21to25];
    
    NSLog(@"_arrayName25 %@", _arrayName25);
    
    NSString *configName =  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"config_name"] ];
    //NSLog(@"configName = %@",  configName );
    [_arrayName1 replaceObjectAtIndex:0 withObject:configName];
    
    NSString *callsign =  [ [NSString alloc] initWithFormat:@"%@", [dictionaryItem valueForKey: @"callsign"] ];
    NSLog(@"setting callsign = %@",  callsign );
    [_arrayName2 replaceObjectAtIndex:0 withObject:callsign];
  
   
    
}



- (void) loadConfigurationData: (NSString*)dataLocation {
    
    
    
    
    customerDataURL = [[NSUserDefaults standardUserDefaults]  stringForKey: @"customerDataURL"]; // includes customer name
    baseDataURL = [[NSUserDefaults standardUserDefaults]  stringForKey: @"baseDataURL"]; // ist root URL to all data perfPool and customer folders
    customerName = [[NSUserDefaults standardUserDefaults]  stringForKey:@"customerFolderName"];
    
    NSString *customerComKey = [[NSUserDefaults standardUserDefaults]  stringForKey:@"_inputCommunicationKey"];
    
    NSLog(@"********** importConfigurations   customerName %@", customerName);
    
    NSString *dedicatedCustomerData  = [[NSUserDefaults standardUserDefaults]  stringForKey: @"dedicatedCustomerData"];
    if (dedicatedCustomerData.length < 2) {
        dedicatedCustomerData = @"";
    }
    NSLog(@"*dedicatedCustomerData %@", dedicatedCustomerData);
    if ([dedicatedCustomerData rangeOfString:@"loadTOemail"].location != NSNotFound  ) { 
        NSString *emailTextURL = [ [NSString alloc] initWithFormat:@"%@%@", customerDataURL,  @"emailTO.txt" ];
        NSURL *URL;
        NSStringEncoding encoding;
        NSError *error;
        URL = [NSURL URLWithString: emailTextURL];       
        NSString *emailText = [NSString stringWithContentsOfURL:URL usedEncoding:&encoding error:&error];
        emailText  = [emailText stringByReplacingOccurrencesOfString:@"\t" withString:@""];
        emailText  = [emailText stringByReplacingOccurrencesOfString:@"\n" withString:@""];
        emailText  = [emailText stringByReplacingOccurrencesOfString:@" " withString:@""];
        NSLog( @"emailText %@", emailText);
        [[NSUserDefaults standardUserDefaults]   setObject: emailText   forKey:@"_defaultEmailAddress"];
      
    }
    
    if ([dedicatedCustomerData rangeOfString:@"loadCCemail"].location != NSNotFound  ) { 
        NSString *emailTextURL = [ [NSString alloc] initWithFormat:@"%@%@", customerDataURL,  @"emailCC.txt" ];
        NSURL *URL;
        NSStringEncoding encoding;
        NSError *error;
        URL = [NSURL URLWithString: emailTextURL];
        [[NSURLCache sharedURLCache] removeAllCachedResponses];
        [[NSURLCache sharedURLCache] setDiskCapacity:0];
        [[NSURLCache sharedURLCache] setMemoryCapacity:0];
        NSString *emailText = [NSString stringWithContentsOfURL:URL usedEncoding:&encoding error:&error];
        emailText  = [emailText stringByReplacingOccurrencesOfString:@"\t" withString:@""];
        emailText  = [emailText stringByReplacingOccurrencesOfString:@"\n" withString:@""];
        emailText  = [emailText stringByReplacingOccurrencesOfString:@" " withString:@""];
        NSLog( @"emailTextCC %@", emailText);
        [[NSUserDefaults standardUserDefaults]   setObject: emailText   forKey:@"_defaultEmailAddressCC"];
      
    }
   
    
    //NSLog(@"customerName %@", customerName);
    //NSLog(@"customerDataURL %@", customerDataURL);

    
    manifestLogoDictionary = [[NSMutableDictionary alloc] init];

    flagLoadOnlyFleetACs = 0;
    if ([dataLocation isEqualToString:@"loadDataFromFleetControl"] ) {
        flagLoadFromFleetControl = 1;
    }else if ([dataLocation isEqualToString:@"loadDataFromFleetControl_myFleetOnly"] ) {
        flagLoadFromFleetControl = 1; flagLoadOnlyFleetACs = 1;
    }else{
        flagLoadFromFleetControl = 0;
    }
    
    
    
    //NSLog(@"importConfiguration dataLocation: %@", dataLocation);
    

    //******************************************************************************************************************************************************************
    
    
    NSURL *URL;
    NSStringEncoding encoding;
    NSError *error;

    //NSLog(@"? 2 loadConfigurationData");
   
    // load equipment list files from iPad
    
    allArrayACRegistration   = [[NSMutableArray alloc] init];
    allArrayConfigurationName   = [[NSMutableArray alloc] init];
    allArrayPackageName   = [[NSMutableArray alloc] init];
    allArrayConfigItemName   = [[NSMutableArray alloc] init];
    allArrayConfigItemWeight   = [[NSMutableArray alloc] init];
    allArrayConfigItemArmLong   = [[NSMutableArray alloc] init];
    allArrayConfigItemMomLong   = [[NSMutableArray alloc] init];
    allArrayConfigItemArmLat   = [[NSMutableArray alloc] init];
    allArrayConfigItemMomLat   = [[NSMutableArray alloc] init];
    allArrayConfigIteminOut   = [[NSMutableArray alloc] init];
    allArrayConfigItemLocked   = [[NSMutableArray alloc] init];
    allArrayConfigItemData   = [[NSMutableArray alloc] init];
    allArrayConfigItemMoved   = [[NSMutableArray alloc] init];    
    allArrayConfigItemAltLong  = [[NSMutableArray alloc] init];
    allArrayConfigItemAltLat   = [[NSMutableArray alloc] init];
    allArrayConfigItemMovable   = [[NSMutableArray alloc] init];
    allArrayConfigItemTrigger   = [[NSMutableArray alloc] init];
    allArrayConfigItemR1   = [[NSMutableArray alloc] init];
    allArrayConfigItemR2   = [[NSMutableArray alloc] init];
    allArrayConfigItemR3   = [[NSMutableArray alloc] init];
    
     NSString *customerFolderName  = [[NSUserDefaults standardUserDefaults]  stringForKey: @"customerFolderName"];
    
     NSLog(@"q1customerFolderName %@", customerFolderName);
    
    if (![customerFolderName isEqualToString:@"noAccount"] ){
        
        importedText = @"";
        if (flagLoadFromFleetControl == 1) {            
            importedText = @"";
            
            
            //load extra images
            
            NSString *extraImagesURL = @"https://www.gyronimo.online/0aaGyroData/extraImages/extraImagesList.txt";
            URL = [NSURL URLWithString: extraImagesURL];
            [[NSURLCache sharedURLCache] removeAllCachedResponses];
            [[NSURLCache sharedURLCache] setDiskCapacity:0];
            [[NSURLCache sharedURLCache] setMemoryCapacity:0];
            NSString *imagesList = [NSString stringWithContentsOfURL:URL usedEncoding:&encoding error:&error];
            imagesList  = [imagesList stringByReplacingOccurrencesOfString:@"\t" withString:@""];
            imagesList  = [imagesList stringByReplacingOccurrencesOfString:@"\n" withString:@""];
            imagesList  = [imagesList stringByReplacingOccurrencesOfString:@" " withString:@""];
            NSLog( @"imagesList %@", imagesList);
            
            //load images
            NSCharacterSet* charSet = [NSCharacterSet characterSetWithCharactersInString:@","];
            NSArray *components = [imagesList componentsSeparatedByCharactersInSet:charSet];
            for(int i =0; i<components.count; i++) {
            
                NSString *imageDataUrl = [ [NSString alloc] initWithFormat:@"%@%@%@", @"https://www.gyronimo.online/0aaGyroData/extraImages/", [components objectAtIndex:i], @".png" ];
                NSLog(@"loading from imageDataUrl: %@", imageDataUrl );  
                
                NSURL *imageURL = [NSURL URLWithString: imageDataUrl ];
                NSData *imageData = [NSData dataWithContentsOfURL:imageURL];
                UIImage *image = [UIImage imageWithData:imageData];
                NSData *imageDataPNG = [NSData dataWithData:UIImagePNGRepresentation(image)];
                
                if (image) {
                    NSString *imageToSave = [NSString stringWithFormat:@"%@", [components objectAtIndex:i] ];
                     [imageDataPNG writeToFile:[imageToSave stringByAppendingPathComponent:@".png"] atomically:YES];         
                     NSArray   *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
                     NSString  *documentsDirectory = [paths objectAtIndex:0];
                     NSString  *filePath = [NSString stringWithFormat:@"%@/%@", documentsDirectory,imageToSave];
                    [imageDataPNG writeToFile:filePath atomically:YES];
                    NSLog(@"saving extraImage named: %@", [components objectAtIndex:i] );
                    
                }else{
                     NSLog(@"error!! No image found for %@", [components objectAtIndex:i] );
                }
                
            }
           
            
            
            
            
            NSString *importAllEquipmentURL = [ [NSString alloc] initWithFormat:@"https://gyronimo.kulanaserver.com/api/default/get_equipment_lists/1.0/?customer=%@", customerComKey ];
            
            //NSString *importAllEquipmentURL = [ [NSString alloc] initWithFormat:@"%@%@", customerDataURL,  @"allEquipment.txt" ];
            
            URL = [NSURL URLWithString: importAllEquipmentURL];
            [[NSURLCache sharedURLCache] removeAllCachedResponses];
            [[NSURLCache sharedURLCache] setDiskCapacity:0];
            [[NSURLCache sharedURLCache] setMemoryCapacity:0];
            importedText = [NSString stringWithContentsOfURL:URL usedEncoding:&encoding error:&error];
            importedText  = [importedText stringByReplacingOccurrencesOfString:@"\t" withString:@""];
            importedText  = [importedText stringByReplacingOccurrencesOfString:@"\n" withString:@""];
          
            NSLog( @"importAllEquipmentURL %@", importAllEquipmentURL);
            NSLog( @"1 importedText -%@-", importedText);
            
            
            if (importedText.length < 1 || [importedText isEqualToString:@""]) {
                
                importAllEquipmentURL = [ [NSString alloc] initWithFormat:@"%@%@", customerDataURL,  @"allEquipment.txt" ];
                NSLog( @"trying old source importAllEquipmentURL%@", importAllEquipmentURL);
                NSLog( @"trying old source ");
                URL = [NSURL URLWithString: importAllEquipmentURL];
                [[NSURLCache sharedURLCache] removeAllCachedResponses];
                [[NSURLCache sharedURLCache] setDiskCapacity:0];
                [[NSURLCache sharedURLCache] setMemoryCapacity:0];
                importedText = [NSString stringWithContentsOfURL:URL usedEncoding:&encoding error:&error];
                importedText  = [importedText stringByReplacingOccurrencesOfString:@"\t" withString:@""];
                importedText  = [importedText stringByReplacingOccurrencesOfString:@"\n" withString:@""];            
            }
            
        }else{
            NSString *importAllEquipmentURL = @"allEquipment";
            NSString *path = [[NSBundle mainBundle] pathForResource:importAllEquipmentURL ofType:@"txt"];
            importedText = [NSString stringWithContentsOfFile:path encoding:NSUTF8StringEncoding error:nil];
            importedText  = [importedText stringByReplacingOccurrencesOfString:@"\t" withString:@""];
            importedText  = [importedText stringByReplacingOccurrencesOfString:@"\n" withString:@""];
        }
        
        NSLog(@"allEquipment importedText %@", importedText  );
       
     
        
        NSCharacterSet* charSet = [NSCharacterSet characterSetWithCharactersInString:@"|"];
        NSArray *components = [importedText componentsSeparatedByCharactersInSet:charSet];
        //NSLog(@"q1components %@", components  );
        
        NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
        [defaults  setObject: [components objectAtIndex:0]    forKey:@"equipmentVersion"];
        //NSLog(@"setting equipmentVersion %@", [components objectAtIndex:0] ); 
        
        
        
        
        for(int i =0; i<components.count-1; i++) {
            
            // each item line
            NSArray* componentItems  = [[components objectAtIndex:i] componentsSeparatedByString:@";"];
            NSLog( @"111componentItems %@", componentItems);
            if (componentItems.count < 3) {
                continue;
            }
            
            // example
            
            
            [allArrayACRegistration        addObject: [componentItems[0] stringByReplacingOccurrencesOfString:@" " withString:@""]    ];
            [allArrayConfigurationName     addObject: [componentItems[1] stringByReplacingOccurrencesOfString:@" " withString:@""]    ];
            [allArrayPackageName           addObject: componentItems [16]];
            [allArrayConfigItemName        addObject: componentItems [3]];
            [allArrayConfigItemWeight      addObject: [componentItems[4] stringByReplacingOccurrencesOfString:@" " withString:@""]    ];
            [allArrayConfigItemArmLong     addObject: [componentItems[5] stringByReplacingOccurrencesOfString:@" " withString:@""]    ];
            [allArrayConfigItemMomLong     addObject: [componentItems[6] stringByReplacingOccurrencesOfString:@" " withString:@""]    ];
            [allArrayConfigItemArmLat      addObject: [componentItems[7] stringByReplacingOccurrencesOfString:@" " withString:@""]    ];
            [allArrayConfigItemMomLat      addObject: [componentItems[8] stringByReplacingOccurrencesOfString:@" " withString:@""]    ];
            [allArrayConfigItemLocked      addObject: [componentItems[9] stringByReplacingOccurrencesOfString:@" " withString:@""]    ];
            [allArrayConfigIteminOut       addObject: [componentItems[10]stringByReplacingOccurrencesOfString:@" " withString:@""]    ];
            [allArrayConfigItemData        addObject: componentItems [11]];
            [allArrayConfigItemAltLong     addObject: componentItems [12]];
            [allArrayConfigItemAltLat      addObject: componentItems [13]];
            [allArrayConfigItemMovable     addObject: componentItems [14]];
            [allArrayConfigItemTrigger     addObject: componentItems [15]];
            [allArrayConfigItemR1          addObject: componentItems [16]];
            [allArrayConfigItemR2          addObject: componentItems [17]];
            [allArrayConfigItemR3          addObject: componentItems [18]];
            
            [allArrayConfigItemMoved        addObject: @"0"];
            
                        
        }
        
        NSLog( @"here  allArrayConfigItemName %@", allArrayConfigItemName); 
        
        
    }else{             
         NSLog( @"starting with noAccount - therefore not loading equipment");        
    }
         
         

    
   

   
    

    
    
    //******************************************************************************************************************************************************************
    
    
        
    arrayConfigButtons = [[NSMutableArray alloc] init];
    arrayConfigurations = [[NSMutableArray alloc] init];
    _arrayName1 = [[NSMutableArray alloc] init];
    _arrayName2 = [[NSMutableArray alloc] init];
    _arrayName3 = [[NSMutableArray alloc] init];
    _arrayName4 = [[NSMutableArray alloc] init];
    _arrayName5 = [[NSMutableArray alloc] init];
    _arrayName6 = [[NSMutableArray alloc] init];
    _arrayName7 = [[NSMutableArray alloc] init];
    _arrayName8 = [[NSMutableArray alloc] init];
    _arrayName9 = [[NSMutableArray alloc] init];
    _arrayName10 = [[NSMutableArray alloc] init];
    _arrayName11 = [[NSMutableArray alloc] init];
    _arrayName12 = [[NSMutableArray alloc] init];
    _arrayName13 = [[NSMutableArray alloc] init];
    _arrayName14 = [[NSMutableArray alloc] init];
    _arrayName15 = [[NSMutableArray alloc] init];
    _arrayName16 = [[NSMutableArray alloc] init];
    _arrayName17 = [[NSMutableArray alloc] init];
    _arrayName18 = [[NSMutableArray alloc] init];
    _arrayName19 = [[NSMutableArray alloc] init];
    _arrayName20 = [[NSMutableArray alloc] init];
    _arrayName21 = [[NSMutableArray alloc] init];
    _arrayName22 = [[NSMutableArray alloc] init];
    _arrayName23 = [[NSMutableArray alloc] init];
    _arrayName24 = [[NSMutableArray alloc] init];
    _arrayName25 = [[NSMutableArray alloc] init];
    


    
    // refresh customer data file
    
    flagWeHaveACustomerFile = 0;
    flagWeHaveAbackendID = 0;
    flagWeHaveAnAircraftBackendID = 0;
    
  
    
    arrayDictAllAircraft = [[NSMutableArray alloc] init]; 
    arrayDictAllAircraft = [[[NSUserDefaults standardUserDefaults] objectForKey:@"arrayDictAllAircraft"] mutableCopy];
    NSLog(@"1 arrayDictAllAircraft %@", arrayDictAllAircraft);
    if (arrayDictAllAircraft.count < 1) {
        arrayDictAllAircraft = [[NSMutableArray alloc] init];
        NSLog(@"!!!! No  arrayDictAllAircraft for configuration");
    }
    
    
     int flagSetDefaultAC = 0;  
    arrayACtypesToLoad = [[NSMutableArray alloc] init];   
    if (arrayACtypesToLoad.count < 1) {
        arrayACtypesToLoad = [[NSMutableArray alloc] init];
    }
    
    NSLog(@"still alive");
    
    
    for (int i=0; i<arrayDictAllAircraft.count; i++) {
        
        NSString *downloadStatus = [[arrayDictAllAircraft objectAtIndex:i] objectForKey:@"downloadStatus"];
        NSString *ACdataSource = [[arrayDictAllAircraft objectAtIndex:i] objectForKey:@"ACdataSource"];
        
        customFilesArray = [[NSMutableArray alloc] init];
        ACCategory = [[arrayDictAllAircraft objectAtIndex:i] objectForKey:@"fleetACCategory"];       
        ACmanufacturer = [[arrayDictAllAircraft objectAtIndex:i] objectForKey:@"Manufacturer"];
        AC_Type = [[arrayDictAllAircraft objectAtIndex:i] objectForKey:@"fleetAC_Type"];
        
        flagWeHaveAbackendID = 0;
        if ( [[[arrayDictAllAircraft objectAtIndex:i] objectForKey:@"ACdataSource"] isEqualToString: @"backend"] ) {                   
               
            
            backendID = [[arrayDictAllAircraft objectAtIndex:i] objectForKey:@"backendID"];
            if (backendID.length > 0) {
                flagWeHaveAbackendID = 1;
                //NSLog(@"config backendid for %@ = %@", AC_Type, [[arrayDictAllAircraft objectAtIndex:i] objectForKey:@"backendID"]); 
            }
            
        }
        
       
        
        
        NSLog(@"making config for  %@", AC_Type);
        ACVariant = [[arrayDictAllAircraft objectAtIndex:i] objectForKey:@"Variant"];   
        NSString *customFiles = [[arrayDictAllAircraft objectAtIndex:i] objectForKey:@"loadedCustomFiles"];
        //NSLog(@"1 customFiles  %@", customFiles);
        if (customFiles.length > 1) {
            customFiles  = [ customFiles stringByReplacingOccurrencesOfString:@" " withString:@""];
            customFiles  = [ customFiles stringByReplacingOccurrencesOfString:@"\n" withString:@""];
            NSArray* componentItemsCustomFiles  = [customFiles componentsSeparatedByString:@"+"];
            for(int i =0; i<componentItemsCustomFiles.count; i++) {
                [customFilesArray addObject:[componentItemsCustomFiles objectAtIndex:i]];
            }
            //NSLog(@"creating customFilesArray for configurations: %@", customFilesArray);
            arrayKey = [ [NSString alloc] initWithFormat:@"%@_%@", AC_Type, @"customFilesArray" ];
            [[NSUserDefaults standardUserDefaults]  setObject:customFilesArray  forKey:arrayKey];
        }
        
        
        int triggerConfigDownload = 1;
        
        if ([downloadStatus isEqualToString:@"acdownloaded"] || [arrayACtypesToLoad containsObject: AC_Type]) { 
            triggerConfigDownload = 0;
            //NSLog(@"already downloaded is: %@", AC_Type); 
        }
        if ([ACdataSource isEqualToString:@"FleetControl"] ) { 
            triggerConfigDownload = 1;
            //NSLog(@"ACdataSource is  FleetControl  for: %@", AC_Type); 
        }
        
        
        
        if (triggerConfigDownload == 1) {
            if ( [[[arrayDictAllAircraft objectAtIndex:i] objectForKey:@"ACdataSource"] isEqualToString: @"FleetControl"] ) {                   
                //NSLog(@"yees load this config data Fleet Control %@", AC_Type);                
                [arrayACtypesToLoad addObject:AC_Type];
                NSLog(@"arrayACtypesToLoad adding %@", AC_Type);
                [self loadConfigPerACType];
                NSMutableDictionary *newDict = [[NSMutableDictionary alloc] init];
                NSDictionary *oldDict = (NSDictionary *)[arrayDictAllAircraft objectAtIndex:i];
                [newDict addEntriesFromDictionary:oldDict];        
                [newDict setObject:@"acdownloaded" forKey:@"downloadStatus"]; 
                [arrayDictAllAircraft replaceObjectAtIndex:i withObject:newDict]; 
                [[NSUserDefaults standardUserDefaults]  setObject: arrayDictAllAircraft  forKey:@"arrayDictAllAircraft"];
                
            } 
            
            if ( [[[arrayDictAllAircraft objectAtIndex:i] objectForKey:@"ACdataSource"] isEqualToString: @"backend"] ) {                   
                //NSLog(@"yees load this config data Backend %@", AC_Type);                
                [arrayACtypesToLoad addObject:AC_Type];
                //NSLog(@"arrayACtypesToLoad adding %@", AC_Type);
                [self loadConfigPerACType];
                NSMutableDictionary *newDict = [[NSMutableDictionary alloc] init];
                NSDictionary *oldDict = (NSDictionary *)[arrayDictAllAircraft objectAtIndex:i];
                [newDict addEntriesFromDictionary:oldDict];        
                [newDict setObject:@"acdownloaded" forKey:@"downloadStatus"]; 
                [arrayDictAllAircraft replaceObjectAtIndex:i withObject:newDict];
                [[NSUserDefaults standardUserDefaults]  setObject: arrayDictAllAircraft  forKey:@"arrayDictAllAircraft"];
                
            }
            
            // set default aircraft
            if (flagSetDefaultAC == 0) {
                flagSetDefaultAC = 1;
                [[NSUserDefaults standardUserDefaults]  setObject:ACCategory                    forKey:@"ACCategory"];
                [[NSUserDefaults standardUserDefaults]  setObject:ACmanufacturer                forKey:@"ACmanufacturer"];
                [[NSUserDefaults standardUserDefaults]  setObject:AC_Type                       forKey:@"AC_Type"];
                [[NSUserDefaults standardUserDefaults]  setObject:ACVariant                     forKey:@"ACVariant"];               
                //NSLog(@"set default aircraft %@", AC_Type);
                
            }
        }
        
       
        
        
        
    }
    
    [[NSUserDefaults standardUserDefaults]  setObject:arrayACtypesToLoad       forKey:@"arrayACtypesToLoad" ];
  
    
  
    [[NSUserDefaults standardUserDefaults]  setObject:availableACManufacturerArray  forKey:@"availableACManufacturerArray" ];    
    //NSLog( @"arrayBackendIDforACtype ...... %@", arrayBackendIDforACtype );
  
    
}


- (void) loadConfigPerACType {

    NSLog(@"loadConfigPerACType %@", AC_Type);   
    
    [arrayConfigButtons removeAllObjects];
    [arrayConfigButtons addObject:@"-"];
    [arrayConfigurations removeAllObjects];
    [arrayConfigurations addObject:@"-"];
    
    NSMutableArray *arrayConfigButtonsRegistration   = [[NSMutableArray alloc] init];
    [arrayConfigButtonsRegistration addObject:@"-"];
             
    NSString *note = AC_Type;
    [[NSNotificationCenter defaultCenter] postNotificationName: @"noteFromPerformance" object: note];       
         
    NSURL *URL;
    NSString *availableConfigurationNameUrl;
    NSString *configText = @"";        
    arrayKey = [ [NSString alloc] initWithFormat:@"%@_%@", AC_Type, @"customFilesArray" ];
    customFilesArray = [[NSMutableArray alloc] init];
    customFilesArray = [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy]; 
    
    NSLog(@"flagWeHaveAbackendID %d", flagWeHaveAbackendID);
        
    if (flagWeHaveAbackendID == 0) {
        
        if (flagLoadFromFleetControl == 1) {
            
            // check if we need to load the generic file or the custom file from the customer folder
            if ([customFilesArray containsObject: @"configurations"]) {
                availableConfigurationNameUrl = [ [NSString alloc] initWithFormat:@"%@%@_configurations.txt", customerDataURL, AC_Type];
                //NSLog( @"loading config from customerDataURL : %@  ", availableConfigurationNameUrl);
            }else{
                availableConfigurationNameUrl = [ [NSString alloc] initWithFormat:@"%@%@%@_%@/%@_configurations.txt", baseDataURL, @"perfPool/", ACmanufacturer, AC_Type, AC_Type];
                //NSLog( @"loading config from baseDataURL : %@  ", availableConfigurationNameUrl);
            }
            
            URL = [NSURL URLWithString: availableConfigurationNameUrl];        
            //NSLog( @"availableConfigurationNameUrl : %@  ", availableConfigurationNameUrl);                
            [[NSURLCache sharedURLCache] removeAllCachedResponses];
            [[NSURLCache sharedURLCache] setDiskCapacity:0];
            [[NSURLCache sharedURLCache] setMemoryCapacity:0];
            NSStringEncoding encoding;
            NSError *error;
            configText = [NSString stringWithContentsOfURL:URL usedEncoding:&encoding error:&error];
            configText = [configText substringToIndex:[configText length] - 1];
            NSLog(@"Fleet Control text for interior_config >%@<", configText);
            
        }else{
            //NSLog( @"getting data from disk");        
            availableConfigurationNameUrl = [ [NSString alloc] initWithFormat:@"%@_configurations", AC_Type ];
            NSString *path = [[NSBundle mainBundle] pathForResource:availableConfigurationNameUrl ofType:@"txt"];
            configText = [NSString stringWithContentsOfFile:path encoding:NSUTF8StringEncoding error:nil];
            configText = [configText substringToIndex:[configText length] - 1];     
             NSLog(@"From Disk text for interior_config >%@<", configText);
        }
        
    }else{
        
        // with backend
        //NSLog(@"with backendID"); 
        NSString *urlWithConfigID =  [ [NSString alloc] initWithFormat:@"https://www.gyronimoserver.com/api/aircraft/%@", backendID];
        NSURL *url = [NSURL URLWithString:urlWithConfigID];
        NSError *error = nil;
        NSURLResponse *response = nil;
        NSData *data = [[NSURLSession sharedSession] sendSynchronousDataTaskWithURL:url returningResponse:&response error:&error];        
        
        NSDictionary *dictionaryAll = [NSJSONSerialization JSONObjectWithData:data options:0 error:&error]; 
        //NSLog(@"dictionaryAll: %@", dictionaryAll);  
        backendDictionaryAircraftData = [dictionaryAll valueForKey:@"aircraft"];        
        
        configText =  [ [NSString alloc] initWithFormat:@"%@", [backendDictionaryAircraftData valueForKey: @"interior_config"]];
        configText = [configText substringToIndex:[configText length] - 1];            
        NSLog(@"backend text for interior_config >%@<", configText);
        
        
    }
    
    //NSLog( @"loaded configText: %@", configText);
    
    if (configText.length < 1) {
        NSLog( @"!!!! missing file:  _configurations.txt");
    }
    
    
    
    // separate loaded string into configurations
    NSCharacterSet* charSet1 = [NSCharacterSet characterSetWithCharactersInString:@"^"];
    NSArray *configurations = [configText componentsSeparatedByCharactersInSet:charSet1];
    
    
    //maxConfigs = configurations.count ;
    //NSLog(@"configurations.count %d", configurations.count );    
    // read each configuration, get name and allocate to arrays
    
    NSLog(@"1 loadConfigPerACType");
   
       
    for (int i = 0; i<configurations.count; i++) {
        
        NSString *configName =@"";
        
        NSString *configString = [configurations objectAtIndex:i];
        NSCharacterSet* charSet = [NSCharacterSet characterSetWithCharactersInString:@"|"];
        NSArray *components = [configString componentsSeparatedByCharactersInSet:charSet];
        NSArray* componentItems;
        
        componentItems  = [[components objectAtIndex:0] componentsSeparatedByString:@","];
        
        //NSLog(@"11components for %@ -%@-", AC_Type, components );
        
        
        //NSLog(@"componentItems %@", componentItems );
        
        //check if config is old or new style via frontend
        configID = @"";
        if ([ [componentItems objectAtIndex:0] rangeOfString:@"configID"].location != NSNotFound  ) {
            
            //NSLog(@"found configID - get data from frontend");
            importedText = [componentItems objectAtIndex:1];
            //NSLog(@"importedText -%@-", importedText );            
            importedText  = [importedText stringByReplacingOccurrencesOfString:@"\t" withString:@""];
            importedText  = [importedText stringByReplacingOccurrencesOfString:@"\n" withString:@""];
            configID = importedText;
            //NSLog(@"configID -%@-", configID );
            
            [self getDataFromAPI];
            NSString *tempConfigName = [_arrayName1 objectAtIndex:0] ;
            configName = [tempConfigName stringByReplacingOccurrencesOfString:@" " withString:@""];
            //NSLog(@"configName from frontend %@", configName);
            
            acReg = [_arrayName2 objectAtIndex:0] ;
            
            //NSLog(@"acReg from frontend %@", acReg);
            
            defaultConfigName =tempConfigName;
            
        }else{
            //NSLog(@"NO configID - get data from Fleet Control");
            componentItems  = [[components objectAtIndex:1] componentsSeparatedByString:@","];
            NSString *tempConfigName = [componentItems objectAtIndex:0] ;
            configName = [tempConfigName stringByReplacingOccurrencesOfString:@" " withString:@""];
            //NSLog(@"configName from Fleet Control %@", configName);
            NSArray* componentItemsEquip  = [[components objectAtIndex:2] componentsSeparatedByString:@","];
            acReg = [componentItemsEquip [0] stringByReplacingOccurrencesOfString:@" " withString:@""];
            defaultConfigName =tempConfigName;            
        }
        
        //NSLog(@"defaultConfigName %@", defaultConfigName);
        
        
        
        if (acReg.length < 1) {
            acReg =@"noReg";
        }
        
       
        
        
        if ([configID isEqualToString:@""]) {
            
            
            [_arrayName1 removeAllObjects];
            [_arrayName2 removeAllObjects];
            [_arrayName3 removeAllObjects];
            [_arrayName4 removeAllObjects];
            [_arrayName5 removeAllObjects];
            [_arrayName6 removeAllObjects];
            [_arrayName7 removeAllObjects];
            [_arrayName8 removeAllObjects];
            [_arrayName9 removeAllObjects];
            [_arrayName10 removeAllObjects];
            [_arrayName11 removeAllObjects];
            [_arrayName12 removeAllObjects];
            [_arrayName13 removeAllObjects];
            [_arrayName14 removeAllObjects];
            [_arrayName15 removeAllObjects];
            [_arrayName16 removeAllObjects];
            [_arrayName17 removeAllObjects];
            [_arrayName18 removeAllObjects];
            [_arrayName19 removeAllObjects];
            [_arrayName20 removeAllObjects];
            [_arrayName21 removeAllObjects];
            [_arrayName22 removeAllObjects];
            [_arrayName23 removeAllObjects];
            [_arrayName24 removeAllObjects];
            [_arrayName25 removeAllObjects];
            
            
           
            
            
            
            
            componentItems  = [[components objectAtIndex:1] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName1 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:2] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName2 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:3] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName3 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:4] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName4 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:5] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName5 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:6] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName6 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:7] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName7 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:8] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName8 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:9] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName9 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:10] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName10 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:11] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName11 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:12] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName12 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:13] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName13 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:14] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName14 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:15] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName15 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:16] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName16 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:17] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName17 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:18] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName18 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:19] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName19 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:20] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName20 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:21] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName21 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:22] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName22 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:23] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName23 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:24] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName24 addObject:[componentItems objectAtIndex:i] ];  }
            componentItems  = [[components objectAtIndex:25] componentsSeparatedByString:@","];
            for (int i = 0; i<componentItems.count; i++) { [_arrayName25 addObject:[componentItems objectAtIndex:i] ];  }
            
        }
        
        
        //NSLog(@"_arrayName2 %@", _arrayName2);
        
        [arrayConfigurations addObject: defaultConfigName];
        [arrayConfigButtons addObject: [ [NSString alloc] initWithFormat:@"%d", i+1  ]];
        
        [arrayConfigButtonsRegistration addObject: acReg];
        
        
        NSMutableArray *arrayPackageName   = [[NSMutableArray alloc] init];
        NSMutableArray *arrayConfigItemName   = [[NSMutableArray alloc] init];
        NSMutableArray *arrayConfigItemWeight   = [[NSMutableArray alloc] init];
        NSMutableArray *arrayConfigItemArmLong   = [[NSMutableArray alloc] init];
        NSMutableArray *arrayConfigItemMomLong   = [[NSMutableArray alloc] init];
        NSMutableArray *arrayConfigItemArmLat   = [[NSMutableArray alloc] init];
        NSMutableArray *arrayConfigItemMomLat   = [[NSMutableArray alloc] init];
        NSMutableArray *arrayConfigItemLocked   = [[NSMutableArray alloc] init];
        NSMutableArray *arrayConfigIteminOut   = [[NSMutableArray alloc] init];
        NSMutableArray *arrayConfigItemData   = [[NSMutableArray alloc] init];
        NSMutableArray *arrayConfigItemMoved   = [[NSMutableArray alloc] init];
        
        NSMutableArray *arrayConfigItemAltLong   = [[NSMutableArray alloc] init];
        NSMutableArray *arrayConfigItemAltLat   = [[NSMutableArray alloc] init];
        NSMutableArray *arrayConfigItemMovable   = [[NSMutableArray alloc] init];
        NSMutableArray *arrayConfigItemTrigger   = [[NSMutableArray alloc] init];
        
        NSMutableArray *arrayConfigItemItemR1   = [[NSMutableArray alloc] init];
        NSMutableArray *arrayConfigItemItemR2   = [[NSMutableArray alloc] init];
        NSMutableArray *arrayConfigItemItemR3   = [[NSMutableArray alloc] init];
        
        
        //NSLog( @"allArrayACRegistration %@", allArrayACRegistration);  
        
        //NSLog( @"1acReg %@", acReg);  
        
        //NSLog( @"configName %@", configName);  
        
        // find matching ac
        for(int objects =0; objects<allArrayACRegistration.count; objects++) {                
            //NSLog( @"ac -%@- at objects %d", [allArrayACRegistration objectAtIndex:objects], objects );                
            
            if ([[allArrayACRegistration objectAtIndex:objects] isEqualToString:acReg]) {
                //NSLog( @"matching ac -%@- at objects %d", [allArrayACRegistration objectAtIndex:objects], objects );
                // find matching config
                if ([[allArrayConfigurationName objectAtIndex:objects] isEqualToString:configName]) {
                    //NSLog( @"matching ac -%@- and config %@ at objects %d", [allArrayACRegistration objectAtIndex:objects], configName, objects );
                    [arrayPackageName            addObject: [allArrayPackageName objectAtIndex:objects]];
                    [arrayConfigItemName         addObject: [allArrayConfigItemName objectAtIndex:objects]];
                    [arrayConfigItemWeight       addObject: [allArrayConfigItemWeight objectAtIndex:objects]];
                    [arrayConfigItemArmLong      addObject: [allArrayConfigItemArmLong objectAtIndex:objects]];
                    [arrayConfigItemMomLong      addObject: [allArrayConfigItemMomLong objectAtIndex:objects]];
                    [arrayConfigItemArmLat       addObject: [allArrayConfigItemArmLat objectAtIndex:objects]];
                    [arrayConfigItemMomLat       addObject: [allArrayConfigItemMomLat objectAtIndex:objects]];
                    [arrayConfigItemLocked       addObject: [allArrayConfigItemLocked objectAtIndex:objects]];
                    [arrayConfigIteminOut        addObject: [allArrayConfigIteminOut objectAtIndex:objects]];
                    [arrayConfigItemData         addObject: [allArrayConfigItemData objectAtIndex:objects]];
                    [arrayConfigItemMoved        addObject: [allArrayConfigItemMoved objectAtIndex:objects]];
                    [arrayConfigItemAltLong      addObject: [allArrayConfigItemAltLong objectAtIndex:objects]];
                    [arrayConfigItemAltLat       addObject: [allArrayConfigItemAltLat objectAtIndex:objects]];
                    [arrayConfigItemMovable      addObject: [allArrayConfigItemMovable objectAtIndex:objects]];
                    [arrayConfigItemTrigger      addObject: [allArrayConfigItemTrigger objectAtIndex:objects]];                        
                    [arrayConfigItemItemR1       addObject: [allArrayConfigItemR1 objectAtIndex:objects]];
                    [arrayConfigItemItemR2       addObject: [allArrayConfigItemR2 objectAtIndex:objects]];
                    [arrayConfigItemItemR3       addObject: [allArrayConfigItemR3 objectAtIndex:objects]];
                    
                }
            }
        }
        
        NSString *key = [NSString stringWithFormat:@"defaultEquip_%@_%@", acReg, configName];
        
        [[NSUserDefaults standardUserDefaults]  setObject:arrayPackageName     forKey:[key stringByAppendingString:@"arrayPackageName"]];
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigItemName     forKey:[key stringByAppendingString:@"arrayConfigItemName"]];
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigItemWeight     forKey:[key stringByAppendingString:@"arrayConfigItemWeight"]];
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigItemArmLong     forKey:[key stringByAppendingString:@"arrayConfigItemArmLong"]];
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigItemMomLong     forKey:[key stringByAppendingString:@"arrayConfigItemMomLong"]];
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigItemArmLat     forKey:[key stringByAppendingString:@"arrayConfigItemArmLat"]];
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigItemMomLat     forKey:[key stringByAppendingString:@"arrayConfigItemMomLat"]];
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigItemLocked     forKey:[key stringByAppendingString:@"arrayConfigItemLocked"]];
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigIteminOut     forKey:[key stringByAppendingString:@"arrayConfigIteminOut"]];
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigItemData     forKey:[key stringByAppendingString:@"arrayConfigItemData"]];
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigItemMoved     forKey:[key stringByAppendingString:@"arrayConfigItemMoved"]];
        
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigItemAltLong     forKey:[key stringByAppendingString:@"arrayConfigItemAltLong"]];
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigItemAltLat     forKey:[key stringByAppendingString:@"arrayConfigItemAltLat"]];
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigItemMovable     forKey:[key stringByAppendingString:@"arrayConfigItemMovable"]];
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigItemTrigger     forKey:[key stringByAppendingString:@"arrayConfigItemTrigger"]];
        
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigItemItemR1     forKey:[key stringByAppendingString:@"arrayConfigItemItemR1"]];
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigItemItemR2     forKey:[key stringByAppendingString:@"arrayConfigItemItemR2"]];
        [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigItemItemR3     forKey:[key stringByAppendingString:@"arrayConfigItemItemR3"]];
        
        NSLog( @"saved equip key %@", key);
        NSLog( @"saved arrayConfigItemName %@", arrayConfigItemName);
     
        
        [self saveArrayListo];
        
        
        
    }
    
    
    
    [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigurations     forKey:[NSString stringWithFormat:@"arrayConfigurations%@", AC_Type]   ];
    
    [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigButtons      forKey:[NSString stringWithFormat:@"arrayConfigButtons%@", AC_Type]   ];
    
    [[NSUserDefaults standardUserDefaults]  setObject:arrayConfigButtonsRegistration      forKey:[NSString stringWithFormat:@"arrayConfigButtonsRegistration%@", AC_Type]   ];
    
    
    [[NSUserDefaults standardUserDefaults]  setObject:acReg      forKey:@"initialAcReg"  ];
    [[NSUserDefaults standardUserDefaults]  setObject:AC_Type      forKey:@"initialAC_Type"  ];
    
    
    //NSLog(@"saving arrayConfigButtons %@ ", arrayConfigButtons);
    
    //NSLog(@"saving arrayConfigurations AC_Type  -%@- = %@ ", AC_Type, arrayConfigurations);
    
    //NSLog(@"saving arrayConfigButtonsRegistration %@ ", arrayConfigButtonsRegistration);
    
    
}


- (void)saveArrayListo {
    
    
    
    // save list
    
    NSUserDefaults *defaults  = [NSUserDefaults standardUserDefaults];
        NSString *configSetup  = [NSString stringWithFormat:@"%@_%@_%@", AC_Type, acReg, defaultConfigName ];
    
    //NSLog(@"saveArrayListo configSetup  %@", configSetup);
    
    
    //NSLog( @"saving  arrayName1 %@", _arrayName1);
    
    [defaults  setObject:self.arrayName1       forKey:[configSetup stringByAppendingString:@"arrayName1"]];
    [defaults  setObject:self.arrayName2       forKey:[configSetup stringByAppendingString:@"arrayName2"]];
    [defaults  setObject:self.arrayName3       forKey:[configSetup stringByAppendingString:@"arrayName3"]];
    [defaults  setObject:self.arrayName4       forKey:[configSetup stringByAppendingString:@"arrayName4"]];
    [defaults  setObject:self.arrayName5       forKey:[configSetup stringByAppendingString:@"arrayName5"]];
    [defaults  setObject:self.arrayName6       forKey:[configSetup stringByAppendingString:@"arrayName6"]];
    [defaults  setObject:self.arrayName7       forKey:[configSetup stringByAppendingString:@"arrayName7"]];
    [defaults  setObject:self.arrayName8       forKey:[configSetup stringByAppendingString:@"arrayName8"]];
    [defaults  setObject:self.arrayName9       forKey:[configSetup stringByAppendingString:@"arrayName9"]];
    [defaults  setObject:self.arrayName10      forKey:[configSetup stringByAppendingString:@"arrayName10"]];
    [defaults  setObject:self.arrayName11      forKey:[configSetup stringByAppendingString:@"arrayName11"]];
    [defaults  setObject:self.arrayName12      forKey:[configSetup stringByAppendingString:@"arrayName12"]];
    [defaults  setObject:self.arrayName13      forKey:[configSetup stringByAppendingString:@"arrayName13"]];
    [defaults  setObject:self.arrayName14      forKey:[configSetup stringByAppendingString:@"arrayName14"]];
    [defaults  setObject:self.arrayName15      forKey:[configSetup stringByAppendingString:@"arrayName15"]];
    [defaults  setObject:self.arrayName16      forKey:[configSetup stringByAppendingString:@"arrayName16"]];
    [defaults  setObject:self.arrayName17      forKey:[configSetup stringByAppendingString:@"arrayName17"]];
    [defaults  setObject:self.arrayName18      forKey:[configSetup stringByAppendingString:@"arrayName18"]];
    [defaults  setObject:self.arrayName19      forKey:[configSetup stringByAppendingString:@"arrayName19"]];
    [defaults  setObject:self.arrayName20      forKey:[configSetup stringByAppendingString:@"arrayName20"]];
    [defaults  setObject:self.arrayName21      forKey:[configSetup stringByAppendingString:@"arrayName21"]];
    [defaults  setObject:self.arrayName22      forKey:[configSetup stringByAppendingString:@"arrayName22"]];
    [defaults  setObject:self.arrayName23      forKey:[configSetup stringByAppendingString:@"arrayName23"]];
    [defaults  setObject:self.arrayName24      forKey:[configSetup stringByAppendingString:@"arrayName24"]];
    [defaults  setObject:self.arrayName25      forKey:[configSetup stringByAppendingString:@"arrayName25"]];
    
    
    NSLog(@"saving  arrayName2  %@", _arrayName2 );
    NSLog(@"saving  arrayName2 key  %@", configSetup );
    //NSLog(@"saving  arrayName22  %@", _arrayName22 );
    
    return;
    
    
    
    
    
}



@end
